/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.Ticker;
import javax.microedition.midlet.MIDlet;

public class RacingCar
extends MIDlet
implements CommandListener,
ItemStateListener {
    private Display display = Display.getDisplay((MIDlet)this);
    private Form openingForm;
    private Form loadingForm = new Form("Loading...");
    private Form resultsForm;
    private Form helpForm;
    private Command helpCommand;
    private Command startCommand;
    private Command backCommand;
    private Command exitCommand;
    private Command againCommand;
    private Image mainCarImg;
    private Image[] img;
    private Gauge gauge = new Gauge("Please wait", false, 7, 1);
    private AnimationCanvas animationCanvas;
    private int width;
    private int height;
    private boolean touchScreenSupported;
    private boolean wasLoaded = false;
    private Thread thread;

    public RacingCar() {
        this.loadingForm.append((Item)this.gauge);
        this.display.setCurrent((Displayable)this.loadingForm);
        System.out.println("loading form was instantiated and set as the current displayable");
        this.thread = new Thread(){

            public void run() {
                RacingCar.access$002(RacingCar.this, new Image[2]);
                try {
                    ((RacingCar)RacingCar.this).img[0] = Image.createImage((String)"/mainPic.png");
                    ((RacingCar)RacingCar.this).img[1] = Image.createImage((String)"/otherPic.png");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                RacingCar.this.openingForm = new Form("");
                RacingCar.this.helpCommand = new Command("Help", 2, 1);
                RacingCar.this.startCommand = new Command("Start", 4, 1);
                RacingCar.this.openingForm.setTicker(new Ticker("Visit www.jacado.com and get more awesome midlets..."));
                RacingCar.this.openingForm.addCommand(RacingCar.this.helpCommand);
                RacingCar.this.openingForm.addCommand(RacingCar.this.startCommand);
                RacingCar.this.gauge.setValue(2);
                RacingCar.this.openingForm.setCommandListener((CommandListener)RacingCar.this);
                try {
                    RacingCar.this.mainCarImg = Image.createImage((String)"/racing.png");
                    RacingCar.this.openingForm.append((Item)new ImageItem(null, RacingCar.this.mainCarImg, 513, "[CAR IMAGE]"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                RacingCar.this.gauge.setValue(3);
                RacingCar.this.openingForm.append((Item)new StringItem("RacingCar v1.1Beta was developed by", "\nJACADO\nwww.jacado.com\n\nThis software is provided \"AS IS\", without warranty of any kind. In no event, shell we be liable for any claim, damages or other liability. Copyright(c)2001 Haim Michael, JACADO & ZINDELL Ltd. All rights reserved."));
                RacingCar.this.resultsForm = new Form("Game Score");
                RacingCar.this.exitCommand = new Command("Exit", 7, 1);
                RacingCar.this.againCommand = new Command("Again", 4, 1);
                RacingCar.this.resultsForm.addCommand(RacingCar.this.exitCommand);
                RacingCar.this.resultsForm.addCommand(RacingCar.this.againCommand);
                RacingCar.this.resultsForm.setCommandListener((CommandListener)RacingCar.this);
                RacingCar.this.gauge.setValue(4);
                RacingCar.this.animationCanvas = new AnimationCanvas();
                RacingCar.this.helpForm = new Form("Help");
                String str = null;
                str = "Using the arrow keys, you shoud move the racing car so it won't crush with the other cars. ";
                RacingCar.this.helpForm.append((Item)new StringItem("Instructions\n", str));
                RacingCar.this.gauge.setValue(5);
                RacingCar.this.backCommand = new Command("Back", 2, 1);
                RacingCar.this.helpForm.addCommand(RacingCar.this.backCommand);
                RacingCar.this.helpForm.setCommandListener((CommandListener)RacingCar.this);
                RacingCar.this.gauge.setValue(6);
                RacingCar.this.animationCanvas.init();
                RacingCar.this.gauge.setValue(7);
                RacingCar.this.display.setCurrent((Displayable)RacingCar.this.openingForm);
                RacingCar.this.wasLoaded = true;
            }
        };
        this.thread.start();
    }

    public void itemStateChanged(Item item) {
    }

    public void commandAction(Command c, Displayable d) {
        if (d == this.openingForm) {
            if (c == this.helpCommand) {
                this.display.setCurrent((Displayable)this.helpForm);
            } else if (c == this.startCommand) {
                this.animationCanvas.startAnimation();
                this.display.setCurrent((Displayable)this.animationCanvas);
            }
        } else if (d == this.helpForm) {
            if (c == this.backCommand) {
                this.display.setCurrent((Displayable)this.openingForm);
            }
        } else if (d == this.resultsForm) {
            if (c == this.exitCommand) {
                this.exit();
            } else if (c == this.againCommand) {
                this.animationCanvas.init();
                this.animationCanvas.startAnimation();
                this.display.setCurrent((Displayable)this.animationCanvas);
            }
        }
    }

    public void exit() {
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void startApp() {
    }

    public void pauseApp() {
        System.out.println("in pause()");
        this.animationCanvas.init();
    }

    public void destroyApp(boolean cond) {
        this.display = null;
        this.openingForm = null;
        this.loadingForm = null;
        this.resultsForm = null;
        this.helpForm = null;
        this.helpCommand = null;
        this.startCommand = null;
        this.backCommand = null;
        this.exitCommand = null;
        this.againCommand = null;
        this.mainCarImg = null;
        this.img = null;
        this.gauge = null;
        this.animationCanvas = null;
        this.thread = null;
    }

    static /* synthetic */ Image[] access$002(RacingCar x0, Image[] x1) {
        x0.img = x1;
        return x1;
    }

    class AnimationCanvas
    extends Canvas
    implements Runnable {
        int currentImg = 0;
        CarsEngine carsEngine = new CarsEngine();
        boolean goOn = true;
        Thread t = null;
        int minX;
        int maxX;
        int x;
        int y;
        long start;
        boolean end;

        AnimationCanvas() {
            RacingCar.this.width = this.getWidth();
            RacingCar.this.height = this.getHeight();
            this.minX = 0;
            this.maxX = RacingCar.this.width - 18;
        }

        void init() {
            this.x = RacingCar.this.width / 2 - 9;
            this.y = RacingCar.this.height - 1 - 18;
            System.out.println("within init() x=" + this.x + " y=" + this.y + " width=" + RacingCar.this.width + " height=" + RacingCar.this.height);
        }

        public void run() {
            System.out.println("start of the run() method");
            while (this.goOn) {
                this.repaint();
                this.serviceRepaints();
                this.carsEngine.tick();
                try {
                    Thread.sleep(150 - this.y);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            System.out.println("end of the run loop within the run() method");
            RacingCar.this.resultsForm.append((Item)new StringItem("score", " " + (System.currentTimeMillis() - this.start) / 1000L));
            RacingCar.this.display.setCurrent((Displayable)RacingCar.this.resultsForm);
            System.out.println("end of run()");
        }

        void startAnimation() {
            this.carsEngine.init(RacingCar.this.width, RacingCar.this.height);
            this.y = RacingCar.this.height - 1 - 18;
            this.start = System.currentTimeMillis();
            this.end = false;
            this.goOn = true;
            if (this.t == null) {
                this.t = new Thread(this);
                this.t.start();
            }
        }

        void stopAnimation() {
            this.goOn = false;
            this.t = null;
        }

        protected void keyPressed(int keyCode) {
            System.out.println("within the keyPressed");
            switch (this.getGameAction(keyCode)) {
                case 2: {
                    this.left();
                    break;
                }
                case 5: {
                    this.right();
                }
            }
        }

        void left() {
            if (this.x > 4) {
                this.x -= 5;
            }
        }

        void right() {
            if (this.x < RacingCar.this.width - 23) {
                this.x += 5;
            }
        }

        public void paint(Graphics g) {
            System.out.println("within paint  x=" + this.x + " y=" + this.y);
            g.setGrayScale(255);
            g.fillRect(0, 0, RacingCar.this.width, RacingCar.this.height);
            g.drawImage(RacingCar.this.img[0], this.x, this.y, 20);
            Location[] locations = this.carsEngine.getLocations();
            g.setGrayScale(0);
            int i = 0;
            while (i < locations.length) {
                g.drawImage(RacingCar.this.img[1], locations[i].x, locations[i].y, 20);
                if ((locations[i].x < this.x && locations[i].x > this.x - 16 || locations[i].x > this.x && locations[i].x < this.x + 16) && locations[i].y < this.y && locations[i].y > this.y - 18) {
                    this.end = true;
                    this.goOn = false;
                    this.stopAnimation();
                }
                ++i;
            }
        }

        class CarsEngine {
            int w;
            int h;
            long count;
            Location[] vec;
            Random random = new Random();

            CarsEngine() {
                this.vec = new Location[4];
            }

            void init(int w, int h) {
                this.count = 0L;
                this.h = h;
                this.w = w;
                this.vec[0] = new Location(0, 0);
                this.vec[1] = new Location(10, -20);
                this.vec[2] = new Location(30, -h);
                this.vec[3] = new Location(40, -2 * h / 3);
            }

            void tick() {
                ++this.count;
                if (this.count % 100L == 0L && this.count < 3000L) {
                    --AnimationCanvas.this.y;
                }
                int i = 0;
                while (i < this.vec.length) {
                    this.vec[i].tick();
                    ++i;
                }
                int i2 = 0;
                while (i2 < this.vec.length) {
                    if (this.vec[i2].y > this.h) {
                        Location temp = new Location();
                        do {
                            temp.x = Math.abs(this.random.nextInt() % (this.w - 18));
                            temp.y = -1 * Math.abs(this.random.nextInt() % (2 * this.h));
                        } while (!this.ok(temp));
                        System.out.println("### temp.x=" + temp.x + " temp.y=" + temp.y);
                        int b = 0;
                        while (b < this.vec.length) {
                            System.out.println("### vec[" + b + "]=" + this.vec[b].x + "," + this.vec[b].y);
                            ++b;
                        }
                        this.vec[i2] = temp;
                    }
                    ++i2;
                }
            }

            boolean ok(Location temp) {
                boolean result = true;
                int i = 0;
                while (i < this.vec.length && result) {
                    if ((temp.x <= this.vec[i].x && temp.x >= this.vec[i].x - 45 || temp.x >= this.vec[i].x && temp.x <= this.vec[i].x + 45) && (temp.y <= this.vec[i].y && temp.y >= this.vec[i].y - 45 || temp.y >= this.vec[i].y && temp.y <= this.vec[i].y + 45)) {
                        result = false;
                    }
                    ++i;
                }
                return result;
            }

            Location[] getLocations() {
                return this.vec;
            }
        }
    }
}

